/**
 * prefUtils.js
 * 0.2
 * 2004-05-17
 * Daniel Lindkvist
 **/

///////////////////////////
// Used With explicit permission (and is GPL) from Daniel Lindkvist
// slightly modified by avih (avihpit [at] yahoo [dot] com) for smoothwheel (2004-11-07)
//   (added onReset handler to load defaults)
///////////////////////////

// settings

if(!org) var org={}; if(!org.mozdev) org.mozdev={}; if(!org.mozdev.smoothwheel) org.mozdev.smoothwheel={};

org.mozdev.smoothwheel.sw_prefutils =
{
  _DEBUG: true,
  AUTO_SET_PREFS: false,

  findIndex: function(groupedItem, value){
    for (i=0; i<groupedItem.firstChild.childNodes.length; i++){
        if (groupedItem.firstChild.childNodes[i].value==value){
            return i;
        }
    }
    
    return 0; // default: return index 0 if value was not found
  },
  _onLoad: function(aDialogId, doResetValues)
  {
    var aWindow = document.getElementById(aDialogId);
    if(org.mozdev.smoothwheel._DEBUG) dump("in onLoad\n");
    if(!aWindow) {
      if(org.mozdev.smoothwheel._DEBUG) dump("No dialog id supplied?\n");
      return;
    }
    var prefElements = aWindow.getElementsByAttribute("prefstring", "*");
    if(!prefElements) {
      if(org.mozdev.smoothwheel._DEBUG) dump("prefElements empty\n");
      return;
    }
    for(var i=0; i<prefElements.length; i++) {
      var prefstring = prefElements[i].getAttribute("prefstring");
      var prefid = prefElements[i].getAttribute("id");
      var preftype = prefElements[i].getAttribute("preftype");
      var elt = prefElements[i].localName;
      var prefdefval = prefElements[i].getAttribute("prefdefval");
      if(!prefdefval)
        prefdefval = "";

      if (!preftype) {
        if (elt == "textbox" || elt=="span")
          preftype = "string";
        else if (elt == "checkbox" || elt == "button")
          preftype = "bool";
        else if (elt == "radiogroup" || elt == "menulist")
//          preftype = "int";
          preftype = "string";//avih: move everything that's not bool to string. will allow floating point values too
      }
      var prefvalue = org.mozdev.smoothwheel.sw_prefutils.getPref(preftype, prefstring, prefdefval);
      if (doResetValues && elt!="span"){
        prefvalue="!/!ERROR_UNDEFINED_PREF!/!";
      } else {
      }
      if(org.mozdev.smoothwheel._DEBUG) dump("pref collected: "+ prefvalue+"\n");
      if(org.mozdev.smoothwheel._DEBUG) dump("elementtype: "+ elt+"\n\n");
      if(prefvalue == "!/!ERROR_UNDEFINED_PREF!/!") {
        prefvalue = prefdefval;
        if(org.mozdev.smoothwheel.AUTO_SET_PREFS)
          org.mozdev.smoothwheel.sw_prefutils.setPref(preftype, prefstring, prefvalue);
      }
      switch(elt) {
        case "textbox":
          prefElements[i].value = prefvalue;
          break;
        case "checkbox":
          prefElements[i].checked = prefvalue;
          break;
        case "button":
          prefElements[i].checked = prefvalue;
          break;
        case "radiogroup":
          prefElements[i].value = org.mozdev.smoothwheel.sw_prefutils.findIndex(prefElements[i], prefvalue);;
          break;
        case "menulist":
          prefElements[i].selectedIndex = org.mozdev.smoothwheel.sw_prefutils.findIndex(prefElements[i], prefvalue);
          break;
        case "span":
          prefElements[i].innerHTML = prefvalue;
          break;
      }
    }
    if(org.mozdev.smoothwheel._DEBUG) dump("init finished\n");
    
  },// end init

  onLoad: function(aDialogId)
  {
    return this._onLoad(aDialogId, false);
  },
  
  onReset: function(aDialogId){
    return this._onLoad(aDialogId, true);
  },//end onReset

  onChange: function(aDialogId){
    alert("onChange called for '"+aDialogId+"'");
  },//end onChange

  onOK: function(aDialogId)
  {
    var aWindow = document.getElementById(aDialogId);
    var prefElements = aWindow.getElementsByAttribute("prefstring", "*");

    for(var i=0; i<prefElements.length; i++) {
      var prefstring = prefElements[i].getAttribute("prefstring");
      var preftype = prefElements[i].getAttribute("preftype");

      var elt = prefElements[i].localName;
      if (!preftype) {
        if (elt == "textbox")
          preftype = "string";
        else if (elt == "checkbox" || elt == "button")
          preftype = "bool";
        else if (elt == "radiogroup" || elt == "menulist")
//          preftype = "int";
          preftype = "string";//avih
      }
      var prefvalue; 
      if (elt == "checkbox")
        prefvalue = prefElements[i].checked;
      else if (elt == "button")
        prefvalue = prefElements[i].checked;
      else if (elt == "radiogroup" || elt == "menulist")
//        prefvalue = prefElements[i].selectedIndex;
        prefvalue = prefElements[i].value;//avih: modified to get value as the programmer intended ;) (instead of the item index)
      else if (elt == "textbox")
        prefvalue = prefElements[i].value;
      else{
        return;//no set pref on read-only
      }

      org.mozdev.smoothwheel.sw_prefutils.setPref(preftype, prefstring, prefvalue);
      if(org.mozdev.smoothwheel._DEBUG) dump("setpref:" +prefstring+" "+ prefvalue + "\n");
    }
    return true;
  },// end onOk


  getPref: function(aPrefType, aPrefString, aDefaultFlag)
  {
    if(org.mozdev.smoothwheel._DEBUG) dump("in getpref\n");
    var pref = Components.classes["@mozilla.org/preferences-service;1"]
        .getService(Components.interfaces.nsIPrefBranch);
    try {
      switch(aPrefType) {
        case "bool":
          return pref.getBoolPref(aPrefString);
          //return !aDefaultFlag ? pref.getBoolPref(aPrefString) : pref.getDefaultBoolPref(aPrefString);
        case "int":
          return pref.getIntPref(aPrefString);
          //return !aDefaultFlag ? pref.getIntPref(aPrefString) : pref.getDefaultIntPref(aPrefString);
        case "localizedstring":
          return pref.getLocalizedUnicharPref(aPrefString); // not working?
        case "color":
        case "string":
        default:
          return pref.getCharPref(aPrefString); 
          //return !aDefaultFlag ? pref.copyUnicharPref(aPrefString) : pref.copyDefaultUnicharPref(aPrefString);
      }
    }catch(e) {
      if(org.mozdev.smoothwheel._DEBUG) {
        dump("*** no default pref for " + aPrefType + " pref: " + aPrefString + "\n");
        dump(e + "\n");
      }
    }
    return "!/!ERROR_UNDEFINED_PREF!/!";
  },


  setPref: function(aPrefType, aPrefString, aValue)
  {
    var pref = Components.classes["@mozilla.org/preferences-service;1"]
        .getService(Components.interfaces.nsIPrefBranch);
    try {
      switch (aPrefType) {
        case "bool":
          pref.setBoolPref(aPrefString, aValue);
          break;
        case "int":
          pref.setIntPref(aPrefString, aValue);
          break;
        case "color":
        case "string":
        case "localizedstring":
        default:
          pref.setCharPref(aPrefString, aValue);
          break;
      }
    }catch(e){
      if(org.mozdev.smoothwheel._DEBUG) dump(e + "\n");
    }
  },
  
//From Foxy-Proxy version 2.18 (File:common.js, License: GPL V2 which is same as SmoothWheel's license): start
//Foxy-Proxy's code is based on the snippest here: https://developer.mozilla.org/En/Code_snippets/Tabbed_browser
//the next 2 functions are used to open a new URL in the most appropriate window.
getMostRecentWindow: function(wm){
    const CI = Components.interfaces;
    const CC = Components.classes;
    var tmp = wm || CC["@mozilla.org/appshell/window-mediator;1"].getService(CI.nsIWindowMediator);
    return tmp.getMostRecentWindow("navigator:browser") || tmp.getMostRecentWindow("Songbird:Main") || tmp.getMostRecentWindow("mail:3pane");
},
// Application-independent version of getEnumerator()
getEnumerator: function() {
    const CI = Components.interfaces;
    const CC = Components.classes;
    var wm = CC["@mozilla.org/appshell/window-mediator;1"].getService(CI.nsIWindowMediator);
    // The next line always returns an object, even if the enum has no elements, so we can't use it to determine between applications
    //var e = wm.getEnumerator("navigator:browser") || wm.getEnumerator("Songbird:Main")
    return wm.getMostRecentWindow("navigator:browser") ? wm.getEnumerator("navigator:browser") : (wm.getEnumerator("Songbird:Main") ? wm.getEnumerator("Songbird:Main") : wm.getEnumerator("mail:3pane"));
},
openAndReuseOneTabPerURL: function(aURL){
    try{
        const CI = Components.interfaces;
        const CC = Components.classes;
      
        var wm = Components.classes["@mozilla.org/appshell/window-mediator;1"].getService(CI.nsIWindowMediator);
        var winEnum = wm.getEnumerator("navigator:browser");
        if (!winEnum.hasMoreElements())
            winEnum = wm.getEnumerator("Songbird:Main");
        if (!winEnum.hasMoreElements())
            winEnm = wm.getEnumerator("mail:3pane");
        while (winEnum.hasMoreElements()){
            var win = winEnum.getNext();
            var browser = win.getBrowser();
            for (var i = 0; i < browser.mTabs.length; i++) {
                if (aURL == browser.getBrowserForTab(browser.mTabs[i]).currentURI.spec) {
                  win.focus(); // bring wnd to the foreground
                  browser.selectedTab = browser.mTabs[i];
                  return;
                }
            }
        }

        // Our URL isn't open. Open it now.
        var w = this.getMostRecentWindow(wm);
        var event = { notify: function(timer) {w.gBrowser.selectedTab = w.gBrowser.addTab(aURL, null, null, null);} }

        if (w){
          // Note: Since TB doesn't support tabs and trunk isn't the same
          // Use an existing browser window
            if(w.messenger) // Thunderbird
                w.messenger.launchExternalURL(aURL);
            else if (!w.delayedOpenTab) /* SongBird, etc. */{
                //setTimeout(function(aTabElt) { w.gBrowser.selectedTab = aTabElt; }, 0, w.gBrowser.addTab(aURL, null, null, null));
                var t = Components.classes["@mozilla.org/timer;1"].createInstance(CI.nsITimer);
                t.initWithCallback(event, 10, CI.nsITimer.TYPE_ONE_SHOT);
            }
            else // FF, SM, Flock, etc.
                w.delayedOpenTab(aURL, null, null, null, null);
                
            w.focus();
        }
    } catch(e){
        var sw=org.mozdev.smoothwheel.ext;
        sw.sw_debugMode&&sw.dbg("!!exception: openAndReuseOneTabPerURL: "+e);
    }
},
//from Foxy-Proxy: end
  
sw_openBrowserWindow: function(url){
    org.mozdev.smoothwheel.sw_prefutils.openAndReuseOneTabPerURL(url);
    return;
},

    
dummy:null};// end sw_prefutils

if(org.mozdev.smoothwheel._DEBUG) dump("in prefutils\n");
