var MMPAppInfo = {
  FIREFOX_ID: "{ec8030f7-c20a-464f-9b0e-13a3a9e97384}",
  THUNDERBIRD_ID: "{3550f703-e582-4d05-9a08-453d09bdfdc6}",
  SEAMONKEY_ID: "{92650c4d-4b8e-4d2a-b7eb-24ecf4f6b63a}",
  MOZILLA_ID: "{86c18b42-e466-45a9-ae7a-9b95ba6f5640}",

  getAppID: function() {
	  var id;
	  if("@mozilla.org/xre/app-info;1" in Components.classes) {
		  // running under Mozilla 1.8 or later
		  id = Components.classes["@mozilla.org/xre/app-info;1"]
			.getService(Components.interfaces.nsIXULAppInfo).ID;
	  } else {
		  try {
			  id = Components.classes["@mozilla.org/preferences-service;1"]
				.getService(Components.interfaces.nsIPrefBranch)
				  .getCharPref("app.id");
		  } catch(e) {
			  // very old version
			  dump(e);
		  }
	  }
	  return id;
  },

  isThunderbird: function() {
	  return this.getAppID() == this.THUNDERBIRD_ID ? true : false;
  },
	
  isSeamonkey: function() {
	  return this.getAppID() == this.SEAMONKEY_ID ? true : false;
  },

  getAppVersion: function() {
	  var appInfo = Components.classes["@mozilla.org/xre/app-info;1"]
		.getService(Components.interfaces.nsIXULAppInfo);

	  return appInfo.version;
  },

  compareVersion: function(ver1, ver2) {
	  var versionChecker = Components.classes["@mozilla.org/xpcom/version-comparator;1"]
		.getService(Components.interfaces.nsIVersionComparator);
	  return versionChecker.compare(ver1, ver2);
  }
};
