var gColMsgPane; //wheather the message pane is collapsed or not in previous setting.
var gIsMaxMsgPane = false; //wheather the message pane is maximized.
var gMaxByMsgDblClick;
var gMMPPref;
var gCollapseList;
var gMMPDelaySettings = false;
var gMMPInitTimerId; //timer ID used for initialization
var gMMPLastSelectedFolderURI = "null";
var gMMPLastSelectedMsgURI = "null";
var gClickPosX = -1;
var gClickPosY = -1;
const MMP_NAVI_BAR_PREV = 1;
const MMP_NAVI_BAR_PREV_UNREAD = 2;
const MMP_NAVI_BAR_NEXT = 3;
const MMP_NAVI_BAR_NEXT_UNREAD = 4;
const MMP_NAVI_BAR_CUR = 5; //Currently read message
const MMP_NAVI_BAR_READ_IT = 6;
const MMP_NAVI_BAR_FIRST = 7;
const MMP_NAVI_BAR_LAST = 8;
const MMP_NAVI_BAR_FIRST_UNREAD = 9;
const MMP_NAVI_BAR_LAST_UNREAD = 10;

function initMMP()
{
	 gMMPPref = Components.classes["@mozilla.org/preferences-service;1"].getService(Components.interfaces.nsIPrefBranch);

	var localeBundle = document.getElementById("localeBundle");
	gCollapseList = new Array();
	
	var aLabel = localeBundle.getString("mmp.layoutmenu.fpmin");
	addMenuItem("mmp_menu_fpmin", aLabel, "key_MinFolderPane", "MMP:FPShow", "ToggleFolderPane();");

	var aLabel = localeBundle.getString("mmp.layoutmenu.mpmax");
	addMenuItem("mmp_menu_mpmax", aLabel, "key_MaxMsgPane", "MMP:MPMax", "ToggleMaxMessagePane();");

	applyMMPSettings();

	//Keyboard shortcut
	var def_skey = "VK_F8";
	var def_mod = [false, false, false, false, true]; //[accel, alt, ctrl, meta, shift]
	setShortcutKey("key_MaxMsgPane","maxmsgpane.",def_skey,def_mod);
	def_skey = "VK_F9";
	def_mod = [false, false, false, false, false];
	setShortcutKey("key_MinFolderPane","maxmsgpane.fp_",def_skey,def_mod);
	addMMPCommand();
	
	try {
		var jumpButton = document.getElementById("button-jump_folder");
		if (jumpButton) {
			jumpButton.setAttribute("disabled","true");
		}
	} catch (e) {
	}

	var messagePaneLayout = document.getElementById("menu_MessagePaneLayout");
	var popupNode = messagePaneLayout.firstChild;
	popupNode.setAttribute("onpopupshown","initMessagePaneTogglingMenu();");

	var folderIsCollapsed = false;
	try {
		folderIsCollapsed = gMMPPref.getBoolPref("maxmsgpane.folder_collapsed_state");
	} catch(e) {
		folderIsCollapsed = false;
	}
	document.getElementById("folderPaneBox").collapsed = folderIsCollapsed;
	
	var threadTree = GetThreadTree();
	threadTree.addEventListener("select",getSelectedMsg,true);

	var folderTree = GetFolderTree();
	folderTree.addEventListener("select",restoreMaxByFolderSelectionChange,true);
	var restoreSession = true;
	try {
		restoreSession = gMMPPref.getBoolPref("maxmsgpane.save_session");
	} catch(e) {
		restoreSession = true;
	}
	if (restoreSession) folderTree.addEventListener("select",MMPSelectFolder,true);
	
	var folderPane = document.getElementById("folderPaneBox");
	folderPane.addEventListener("DOMAttrModified",notifyLayoutChangeByEvent,true);
	var ltn = document.getElementById("ltnModeBox");
	if (ltn) ltn.addEventListener("DOMAttrModified",notifyLayoutChangeByEvent,true);

	var msgPane = GetMessagePane();
	msgPane.addEventListener("DOMAttrModified",notifyLayoutChangeByEvent,true);
	var dispDeck = document.getElementById("displayDeck");
	dispDeck.addEventListener("select",restoreMaxByDeckChange,true);
	notifyLayoutChange();

	gMMPInitTimerId = setInterval(finalizeInitMMP,100);
}

function restoreMaxByDeckChange(aEvent)
{
	var targetId = aEvent.target.id;
	if (targetId != "displayDeck") return;

	if (gIsMaxMsgPane && aEvent.target.selectedPanel.id != "threadPaneBox")
	  ToggleMaxMessagePane();
	else notifyLayoutChange();
}

function notifyLayoutChangeByEvent(aEvent)
{
	var targetId = aEvent.target.id;
	if (targetId != "folderPaneBox" && targetId != "messagepanebox" && targetId != "ltnModeBox")
	  return;

	if (aEvent.attrName == "collapsed") notifyLayoutChange();

}

function initFolderLists(targetId)
{
	if (targetId == "tpmenu-jump_folder_popup"
		|| targetId == "maxbutton-jump_folder_popup"
		|| targetId == "mpmenu-jump_folder_popup"
		|| targetId == "button-jump_folder_popup"){
		var popup = document.getElementById(targetId);
		var menus = popup.childNodes;

		for (var i=0; i<menus.length; i++) {
			initFolderList(menus[i]);
		}
	}
}

function initFolderList(menu)
{
	if (!accountManagerDataSource || !folderDataSource) return;
	var is20 = MMPAppInfo.compareVersion(MMPAppInfo.getAppVersion(), "2.0a1") >= 0;
	if (menu) {
		var nsIRDFDataSource = Components.interfaces.nsIRDFDataSource;

		if (is20)
		  menu.setAttribute("hidden","false");
		else
		  menu.setAttribute("hidden","true");

		switch (menu.getAttribute("mmpjump_filter")) {
		  case "all":
			menu.database.RemoveDataSource(accountManagerDataSource);
			menu.database.RemoveDataSource(folderDataSource);
			menu.database.AddDataSource(accountManagerDataSource);
			menu.database.AddDataSource(folderDataSource);
			menu.removeAttribute('ref', 'msgaccounts:/');
			menu.setAttribute('ref', 'msgaccounts:/');
			menu.setAttribute("hidden","false");
			break;
		  case "unread":
			if (!is20) break;
			menu.database.RemoveDataSource(unreadFolderDataSource);
			menu.database.AddDataSource(unreadFolderDataSource);
			menu.removeAttribute('ref', 'mailnewsunreadfolders:/');
			menu.setAttribute('ref', 'mailnewsunreadfolders:/');
			break;
		  case "favorite":
			if (!is20) break;
			menu.database.RemoveDataSource(favoriteFoldersDataSource);
			menu.database.AddDataSource(favoriteFoldersDataSource);
			menu.removeAttribute('ref', 'mailnewsfavefolders:/');
			menu.setAttribute('ref', 'mailnewsfavefolders:/');
			break;
		  case "recent":
			if (!is20) break;
			menu.database.RemoveDataSource(recentFoldersDataSource);
			menu.database.AddDataSource(recentFoldersDataSource);
			menu.removeAttribute('ref', 'mailnewsrecentfolders:/');
			menu.setAttribute('ref', 'mailnewsrecentfolders:/');
			break;
		  default:
			break;
		}
	}
}

function finalizeInitMMP()
{
	if (gNotifyDefaultInboxLoadedOnStartup) { //detect folder load
		if (!accountManagerDataSource || !folderDataSource) return;
		clearInterval(gMMPInitTimerId);

		//enable jump folder button when the folder data source has loaded.
		var jumpButton = document.getElementById("button-jump_folder");
		if (jumpButton) {
			jumpButton.removeAttribute("disabled");
		}
	}
}

//search box, attachment view, message header are shown when the message selection
//is changed with maximized.
//so these component collapsed again if needed.
function hideComponentAgain()
{
	if (gIsMaxMsgPane) {
		//search box
		try {
			var collapse = gMMPPref.getBoolPref("maxmsgpane.collapse_search");
			var searchBox = document.getElementById("searchBox");
			if (searchBox.collapsed != collapse)
			  searchBox.collapsed = collapse;
		} catch(e) {
		}
		
		//attachments view
		var collapse_attach = false;
		try {
			collapse_attach = gMMPPref.getBoolPref("maxmsgpane.collapse_attach");
		} catch(e){
			collapse_attach = false;
		}
		var attachBox = document.getElementById("attachmentView");
		if (collapse_attach){
			attachBox.collapsed = true;
		} else {
			try {
				if (gDBView) {
					var msgKey = gDBView.keyForFirstSelectedMessage;
					var msgHdr = gDBView.hdrForFirstSelectedMessage;
					if (msgKey && msgHdr) {
						var hasAttach = msgHdr.folder.getMsgDatabase(msgWindow).HasAttachments(msgKey);
						attachBox.collapsed = !hasAttach;
					}
				}
			} catch(e) {
				attachBox.collapsed = true;
			}
		}
	
		//headers view
		try {
			var collapse = gMMPPref.getBoolPref("maxmsgpane.collapse_header");
			var header = document.getElementById("msgHeaderView");
			if (header.collapsed != collapse)
			  header.collapsed = collapse;
		} catch(e) {
		}
	}
}

function restoreMaxByFolderSelectionChange(){
	var restore = false;
	try {
		restore = gMMPPref.getBoolPref("maxmsgpane.folsel_restore");
	} catch(e) {
		restore = false;
	}

//	if (document.getElementById("mmp_navibar").collapsed) restore = true;
	
	if (restore && gIsMaxMsgPane) ToggleMaxMessagePane();
}

function MMPSelectFolder()
{
	var folderTree = GetFolderTree();
	folderTree.removeEventListener("select",MMPSelectFolder,true);
	
	var folderURI = nsPreferences.copyUnicharPref("maxmsgpane.selected_folder","null");
	var msgURI = nsPreferences.copyUnicharPref("maxmsgpane.selected_msg","null");
	try {
		if (folderURI != "null") {
			SelectFolder(folderURI);
			gMMPLastSelectedFolderURI = folderURI;
			if (msgURI != "null") {
				SelectMessage(msgURI);
				gMMPLastSelectedMsgURI = msgURI;
			}
		}
	} catch (e) {
	}
}

window.addEventListener("load", initMMP, false);

function addMenuItem(id, label, key, observe, cmd)
{
	var messagePaneLayout = document.getElementById("menu_MessagePaneLayout");
	if (messagePaneLayout) {
		var popupNode = messagePaneLayout.firstChild;
		var itemNode = document.createElement( "menuitem" );
		itemNode.setAttribute("id", id);
		itemNode.setAttribute("type", "checkbox");
		itemNode.setAttribute("autoCheck", "false");
		itemNode.setAttribute("label",label);
		itemNode.setAttribute("key", key);
		itemNode.setAttribute("oncommand", cmd);
		itemNode.setAttribute("observes", observe);

		popupNode.appendChild(itemNode);
	}
}

function applyMMPSettings()
{
	var idList = [
				"mailContent", 
				"folderpane_splitter",
				"threadpane-splitter",
				"messengerBox",
				"messagepanebox",
				"folderPaneBox",
				"searchBox",
				"msgHeaderView",
				"attachmentView",
				"today-pane-panel", //lightning
				"ltnModeBox" //lightning
				];

	for (i = 0; i < idList.length; i++) {
		var elem = new Array(2);
		elem[1] = true;
		gCollapseList[idList[i]] = elem;
	}
	
	try {
		var col = gMMPPref.getBoolPref("maxmsgpane.collapse_ltntoday");
		gCollapseList["today-pane-panel"][1] = col;
	} catch(e) {
		gCollapseList["today-pane-panel"][1] = false;
	}
	
	try {
		var col = gMMPPref.getBoolPref("maxmsgpane.collapse_folder");
		gCollapseList["folderPaneBox"][1] = col;
		gCollapseList["ltnModeBox"][1] = col;
		  
	} catch(e) {
		gCollapseList["folderPaneBox"][1] = false;
		gCollapseList["ltnModeBox"][1] = false;
	}
	gCollapseList["folderpane_splitter"][1] = false;
	gCollapseList["threadpane-splitter"][1] = false;
	
	try {
		gCollapseList["searchBox"][1] =
		  gMMPPref.getBoolPref("maxmsgpane.collapse_search");
	} catch(e) {
		gCollapseList["searchBox"][1] = false;
	}

	try {
		gCollapseList["msgHeaderView"][1] =
		  gMMPPref.getBoolPref("maxmsgpane.collapse_header");
	} catch(e) {
		gCollapseList["msgHeaderView"][1] = false;
	}

	try {
		gCollapseList["attachmentView"][1] =
		  gMMPPref.getBoolPref("maxmsgpane.collapse_attach");
	} catch(e) {
		gCollapseList["attachmentView"][1] = false;
	}

	gCollapseList["messagepanebox"][1] = false;
	
	try {
		gMaxByMsgDblClick = gMMPPref.getBoolPref("maxmsgpane.msg_dclicked");
	} catch(e) {
		gMaxByMsgDblClick = false;
	}

	//Shortcut for Message Pane
	var useShortcut;
	try {
		useShortcut = gMMPPref.getBoolPref("maxmsgpane.use_shortcut");
	} catch(e) {
		useShortcut = true;
	}
	
	document.getElementById("key_MaxMsgPane").setAttribute("disabled",(!useShortcut).toString());

	//Shortcut for Folder Pane
	try {
		useShortcut = gMMPPref.getBoolPref("maxmsgpane.fp_use_shortcut");
	} catch(e) {
		useShortcut = true;
	}
	
	document.getElementById("key_MinFolderPane").setAttribute("disabled",(!useShortcut).toString());

	//Close button for the folder pane
	try {
		if (gMMPPref.getBoolPref("maxmsgpane.fp_close_button"))
		  document.getElementById("button-closefolder").setAttribute("collapsed","false");
		else
		  document.getElementById("button-closefolder").setAttribute("collapsed","true");
	} catch(e) {
		document.getElementById("button-closefolder").setAttribute("collapsed","false");
	}
}

function setShortcutKey(keyId, prefix, def_skey, def_mod)
{
	var modifiers = new Array();
	try {
		if (gMMPPref.getBoolPref(prefix + 'accel_key'))
		  modifiers.push('accel');
	} catch(e) {
		if (def_mod[0]) modifiers.push('accel');
	}

	try {
		if (gMMPPref.getBoolPref(prefix + 'alt_key'))
		  modifiers.push('alt');
	} catch(e) {
		if (def_mod[1]) modifiers.push('alt');
	}

	try {
		if (gMMPPref.getBoolPref(prefix + 'ctrl_key'))
		  modifiers.push('control');
	} catch(e) {
		if (def_mod[2]) modifiers.push('control');
	}

	try {
		if (gMMPPref.getBoolPref(prefix + 'meta_key'))
		  modifiers.push('meta');
	} catch(e) {
		if (def_mod[3]) modifiers.push('meta');
	}

	try {
		if (gMMPPref.getBoolPref(prefix + 'shift_key'))
		  modifiers.push('shift');
	} catch(e) {
		if (def_mod[4]) modifiers.push('shift');
	}

	var modifierString = null;
	if (modifiers.length > 0 ) modifierString = modifiers.join(' ');

	var skey;
	try {
		skey = gMMPPref.getCharPref(prefix + 'key');
	} catch(e) {
		skey = def_skey;
	}

	if (modifierString)
	  document.getElementById(keyId).setAttribute('modifiers', modifierString);
	var keyAttr = 'key';
	if (skey.indexOf("VK_") == 0) keyAttr = 'keycode';
	document.getElementById(keyId).setAttribute(keyAttr, skey);
}

function addMMPCommand()
{
	var use_tsplitter;
	var hide_MP;

	try {
		use_tsplitter = gMMPPref.getBoolPref("maxmsgpane.tsplitter");
	} catch(e) {
		use_tsplitter = true;
	}
	
	try {
		hide_MP = gMMPPref.getBoolPref("maxmsgpane.tsplitter_hide");
	} catch(e) {
		hide_MP = false;
	}

	if (use_tsplitter) {
		var mouseEvent;
		try {
			mouseEvent = gMMPPref.getIntPref("maxmsgpane.tsplitter_toggle_event");
		} catch (e) {
			mouseEvent = 1;
		}
		var tsplitter = document.getElementById("threadpane-splitter");
		var cmd = hide_MP ? "ToggleFromTSplitter(event, true)" : "ToggleFromTSplitter(event, false)";
		if (mouseEvent == 0) {
			tsplitter.setAttribute("onmousedown","getClickPos(event)");
			tsplitter.setAttribute("onclick",cmd);
		} else if (mouseEvent == 1) {
			tsplitter.setAttribute("onmousedown","getClickPos(event)");
			tsplitter.setAttribute("ondblclick",cmd);
		}
	}

	var use_fsplitter;
	try {
		use_fsplitter = gMMPPref.getBoolPref("maxmsgpane.fsplitter");
	} catch(e) {
		use_fsplitter = true;
	}
	if (use_fsplitter) {
		var mouseEvent;
		try {
			mouseEvent = gMMPPref.getIntPref("maxmsgpane.fsplitter_toggle_event");
		} catch (e) {
			mouseEvent = 1;
		}
		
		var fsplitter = document.getElementById("folderpane_splitter");
		if (mouseEvent == 0) {
			fsplitter.setAttribute("onmousedown","getClickPos(event)");
			fsplitter.setAttribute("onclick","ToggleFromFSplitter(event)");
		} else if (mouseEvent == 1) {
			fsplitter.setAttribute("onmousedown","getClickPos(event)");
			fsplitter.setAttribute("ondblclick","ToggleFromFSplitter(event)");
		}
	}

	var useHdr;
	try {
		var useHdr = gMMPPref.getBoolPref("maxmsgpane.hdr");
	} catch(e) {
		useHdr = false;
	}

	if (useHdr) {
		var hdr_view = document.getElementById("msgHeaderView");
		var setInt;
		try {
			setInt = gMMPPref.getIntPref("maxmsgpane.hdr_toggle_event");
		} catch (e) {
			setInt = 1;
		}
		if (setInt == 0) {
			hdr_view.setAttribute("onmousedown","getClickPos(event)");
			hdr_view.setAttribute("onclick","ToggleFromHdrView(event)");
		} else if (setInt == 1) {
			hdr_view.setAttribute("onmousedown","getClickPos(event)");
			hdr_view.setAttribute("ondblclick","ToggleFromHdrView(event)");
		}
	}
}

var settingObserver = {
  observe:function(aSubject, aTopic, aData){
    if(aTopic == "mmp:setting_updated"){
		gMMPDelaySettings = gIsMaxMsgPane;
		if (!gMMPDelaySettings) applyMMPSettings();
		if (aData == "restart") setTimeout(restartTB, 0); //wait for dialog closing
    }
  }
}

function getClickPos(aEvent)
{
	gClickPosX = aEvent.screenX;
	gClickPosY = aEvent.screenY;
}


var settingObserverService = Components.classes["@mozilla.org/observer-service;1"].getService(Components.interfaces.nsIObserverService);
settingObserverService.addObserver(settingObserver, "mmp:setting_updated", false);


function doMMPCommand(value)
{
	switch (value) {
	  case "MP": ToggleMaxMessagePane(); break;
	  case "FP": ToggleFolderPane(); break;
	  case "TP": MsgToggleMessagePane(); break;
	  default: break;
	}

	return;
}

function ToggleMaxMessagePane()
{
	var paneConfig = gMMPPref.getIntPref("mail.pane_config.dynamic");
	var toggled = false;
	var useNavi = true;
	try {
		useNavi = gMMPPref.getBoolPref("maxmsgpane.use_navi");
	} catch(e) {
		useNavi = true;
	}

	//toggle
	switch (paneConfig) { //classic, wide, vertical layout is supported.
	  case kStandardPaneConfig:
	  case kWidePaneConfig:
	  case kVerticalPaneConfig:
		if (gIsMaxMsgPane) {
			try {
				var browser = document.getElementById("messagepane");
				browser.removeEventListener("load", hideComponentAgain, true);
			} catch(e) {
			}

			toggled = RestorePanes();
			hideMMPNaviBar(); //always hide in case settins is changed while maximization
			SetFocusThreadPane();
		} else {
			toggled = MaximizeMessagePane();
			if (!toggled) break;
			if (useNavi) showMMPNaviBar();
//			if (!gColMsgPane) SetFocusMessagePane();
			if (!gColMsgPane) {
				SetFocusMessagePane();
				GetMessagePaneFrame().focus();
			} else {
				//wait until the message pane is rebuilt.
				setTimeout("SetFocusMessagePane();GetMessagePaneFrame().focus();",500);
			}

			try {
				var browser = document.getElementById("messagepane");
				browser.addEventListener("load", hideComponentAgain, true);
			} catch(e) {
			}
		}
		
		break;
	  default:
	}

	if (toggled) {
		//sync Lightning's elements
		var ltnToday = document.getElementById("today-pane-panel");
		var ltnTodaySplit = document.getElementById("today-splitter");
		if (ltnToday) {
			if (ltnToday.collapsed) {
				if (ltnTodaySplit) ltnTodaySplit.setAttribute("state", "collapsed");
			} else {
				if (ltnTodaySplit) ltnTodaySplit.removeAttribute("state");
			}
		}
		notifyLayoutChange();
	}
}

function outputMessageToStatusBar(str)
{
	document.getElementById("statusText").setAttribute("label",str);
}

function disableMessagePaneToggling(disable)
{
	var val = disable.toString();
	document.getElementById("key_toggleMessagePane").setAttribute("disabled",val);
	document.getElementById("menu_showMessage").setAttribute("disabled",val);
	document.getElementById("MMP:MPShow").setAttribute("disabled",val);
	document.getElementById("MMP:MPMin").setAttribute("disabled",val);
}

function initMessagePaneTogglingMenu()
{
	if (gIsMaxMsgPane) {
		document.getElementById("menu_showMessage").setAttribute("disabled","true");
	} else {
		document.getElementById("menu_showMessage").removeAttribute("disabled");
	}
}

function ToggleFromHdrView(aEvent)
{
//	if (aEvent.which != 1) return; //left-click only
	if (aEvent.which == 3) return; //left/middle-click only
	if (nsPreferences.getBoolPref("maxmsgpane.forbid_lmb_on_hdr", false) && aEvent.which ==1) return;
	
	if (aEvent.originalTarget.localName == "image") return; //+ was clicked
	if (aEvent.originalTarget.localName == "menuitem") return; //context menu item was clicked
	if (aEvent.originalTarget.localName == "button") return; //edit button (draft message)
	if (aEvent.originalTarget.localName == "toolbarbutton") return; //edit button (draft message)
	//URL of RSS message
	if (aEvent.originalTarget.localName == "label"
		&& aEvent.originalTarget.getAttribute("class").search(/headerValueUrl/) != -1) return;
	
	var x = aEvent.screenX;
	var y = aEvent.screenY;
	if (gClickPosX != x || gClickPosY != y) return;

	doMMPCommand("MP");
	return;
}

function ToggleFromTSplitter(aEvent, hideMP)
{
	if (aEvent.which == 3) return; //left/middle-click only
	var x = aEvent.screenX;
	var y = aEvent.screenY;
	if (gClickPosX != x || gClickPosY != y) return;
	
	if (hideMP) {
		if (!gIsMaxMsgPane) doMMPCommand("TP");
	} else {
		doMMPCommand("MP");
	}
}

function ToggleFromFSplitter(aEvent)
{
	if (aEvent.which == 3) return; //left/middle-click only
	var x = aEvent.screenX;
	var y = aEvent.screenY;
	if (gClickPosX != x || gClickPosY != y) return;
	doMMPCommand("FP");
}

function MaximizeMessagePane()
{
	var isMsgPaneCollapsed = GetMessagePane().collapsed;
	var paneConfig = gMMPPref.getIntPref("mail.pane_config.dynamic");
	var threadPaneBox = document.getElementById("threadPaneBox");
	
	//unable to maximize if folderpane exists on wide pane layout
	if (paneConfig == kWidePaneConfig && !gCollapseList["folderPaneBox"][1]) {
		if (!document.getElementById("folderPaneBox").collapsed)
		  return false;
	}

	//other deck is selected
	if (document.getElementById("displayDeck").selectedPanel != threadPaneBox) return false;

	var allowMax = false;
	try {
		allowMax = gMMPPref.getBoolPref("maxmsgpane.allow_max_wo_selection");
	} catch(e) {
	}
	//don't maximize because no message is selected
	try {
		if (!allowMax && gDBView.numSelected != 1) {
			var localeBundle = document.getElementById("localeBundle");
			var str = localeBundle.getString("mmp.err_notmax");
			outputMessageToStatusBar(str);
			return false;
		}
	} catch(e) {
	}
	
	UpdateCollapseList(paneConfig);

	GetMessagePane().flex = 1;
	document.getElementById("mailContent").setAttribute("flex","1");

	Collapse(true);
	if (paneConfig == kWidePaneConfig)
	  document.getElementById("mailContent").setAttribute("flex","0");

	try {
		if (isMsgPaneCollapsed) {
			MsgToggleMessagePane();
			gColMsgPane = true;
		} else {
			gColMsgPane = false;
		}
	} catch(e) {
	};

	gIsMaxMsgPane = true;

	return true;
}

function UpdateCollapseList(paneConfig)
{
	//save current status
	var id;
	for ( id in gCollapseList ){
		var elem = gCollapseList[id];
		if (!elem[1]) continue;
		try {
			elem[0] = document.getElementById(id).collapsed;
		} catch(e) {
		}
	}

	if (paneConfig == kWidePaneConfig) {
		if (gCollapseList["searchBox"][1])
		  gCollapseList["mailContent"][1] = true;
		else
		  gCollapseList["mailContent"][1] = false;
	} else {
		gCollapseList["mailContent"][1] = false;
	}
}

function Collapse(maximize)
{
	var index = maximize ? 1 : 0;
	var id;
	for (id in gCollapseList) {
		if (!gCollapseList[id][1]) continue;
		try {
			document.getElementById(id).collapsed = gCollapseList[id][index];
		} catch(e) {
		}
	}
}

function ToggleFolderPane()
{
	var ltn = document.getElementById("ltnModeBox");
	var fp = document.getElementById("folderPaneBox");
	var focusedPane = WhichPaneHasFocus();
	var folderTree = GetFolderTree();
	var col = ltn ? ltn.collapsed : fp.collapsed;
	
	if (col) {
		if (ltn) ltn.collapsed = false;
		fp.collapsed = false;
		SetFocusFolderPane();
	} else if (!fp.collapsed) {
		if (ltn) ltn.collapsed = true;
		fp.collapsed = true;
		if (focusedPane == folderTree) SetFocusThreadPane();
	}

	notifyLayoutChange();
}

function RestorePanes()
{
	gIsMaxMsgPane = false;
	Collapse(false);
	document.getElementById("mailContent").setAttribute("flex","1");
	
	try {
		if (gColMsgPane) MsgToggleMessagePane();
	} catch(e) {
	};
	
	var paneConfig = gMMPPref.getIntPref("mail.pane_config.dynamic");
	switch (paneConfig) {
	  case kStandardPaneConfig:
		GetMessagePane().flex = 1;
		break;
	  case kWidePaneConfig:
		GetMessagePane().flex = null;
		document.getElementById("mailContent").setAttribute("collapsed","false");
		break;
	  case kVerticalPaneConfig:
		GetMessagePane().flex = null;
		break;
	  default:
		break;
	}

	try {
		if (gDBView) {
			var msgKey = gDBView.keyForFirstSelectedMessage;
			var msgHdr = gDBView.hdrForFirstSelectedMessage;
			if (msgKey && msgHdr) {
				var hasAttach = msgHdr.folder.getMsgDatabase(msgWindow).HasAttachments(msgKey);
				document.getElementById("attachmentView").collapsed = !hasAttach;
			}
		}
	} catch(e) {
	}
	
	if (gMMPDelaySettings) {
		applyMMPSettings();
		gMMPDelaySettings = false;
	}

	return true;
}

function finalizeMMP()
{
	var doesSaveSession;
	try {
		doesSaveSession = gMMPPref.getBoolPref("maxmsgpane.save_session");
	} catch(e) {
		gMMPPref.setBoolPref("maxmsgpane.save_session",true);
		doesSaveSession = true;
	}

	if (gIsMaxMsgPane) ToggleMaxMessagePane();
	var folderpane = document.getElementById("folderPaneBox");
//	var persist = folderpane.getAttribute("persist");
//	if (persist.indexOf("collapsed") == -1) persist = persist + "collapsed";
//	folderpane.setAttribute("persist", persist);
	
	if (!doesSaveSession) {
		folderpane.collapsed = false;
		gMMPLastSelectedFolderURI = "null";
		gMMPLastSelectedMsgURI = "null";
	} else if (gMMPLastSelectedFolderURI == "null") {
		gMMPLastSelectedMsgURI = "null";
	}
	gMMPPref.setBoolPref("maxmsgpane.folder_collapsed_state",folderpane.collapsed);
	nsPreferences.setUnicharPref("maxmsgpane.selected_folder",gMMPLastSelectedFolderURI);
	nsPreferences.setUnicharPref("maxmsgpane.selected_msg",gMMPLastSelectedMsgURI);
}

//Cancel maximization when Thunderbird is finished.
window.addEventListener("unload", finalizeMMP, false);

var ThreadPaneDoubleClickOrg = ThreadPaneDoubleClick;
var ThreadPaneDoubleClick = function()
{
	if (IsSpecialFolderSelected(MSG_FOLDER_FLAG_DRAFTS, true)) {
		ThreadPaneDoubleClickOrg.apply(this,arguments);
		return;
	} else if(IsSpecialFolderSelected(MSG_FOLDER_FLAG_TEMPLATES, true)) {
		ThreadPaneDoubleClickOrg.apply(this,arguments);
		return;
	} else {
		if (gMaxByMsgDblClick) ToggleMaxMessagePane();
		else ThreadPaneDoubleClickOrg.apply(this,arguments);
		return;
	}
}

function ChangeLayout(newLayout)
{
	if (gIsMaxMsgPane) {
		ToggleMaxMessagePane(); //Cancel maximization
		ChangeMailLayout(newLayout);
		ToggleMaxMessagePane(); //Maximize again
	} else {
		ChangeMailLayout(newLayout);
	}
}

function notifyLayoutChange()
{
	if (gIsMaxMsgPane)
		document.getElementById("MMP:MPMax").setAttribute("checked", "true");
	else
		document.getElementById("MMP:MPMax").removeAttribute("checked");

	var fp = document.getElementById("folderPaneBox");
	var ltn = document.getElementById("ltnModeBox");
	var chk = ltn ? ltn.collapsed : fp.collapsed;
	if (chk) {
		document.getElementById("MMP:FPShow").removeAttribute("checked");
		document.getElementById("MMP:FPMin").setAttribute("checked", "true");
	} else {
		document.getElementById("MMP:FPShow").setAttribute("checked", "true");
		document.getElementById("MMP:FPMin").removeAttribute("checked");
	}
	
	chk = GetMessagePane().collapsed;
	if (chk) {
		document.getElementById("MMP:MPShow").removeAttribute("checked");
		document.getElementById("MMP:MPMin").setAttribute("checked", "true");
	} else {
		document.getElementById("MMP:MPShow").setAttribute("checked", "true");
		document.getElementById("MMP:MPMin").removeAttribute("checked");
	}
	switch (document.getElementById("displayDeck").selectedPanel.id) {
	  case "threadPaneBox": //Thread Pane
		disableMessagePaneToggling(gIsMaxMsgPane);
		//document.getElementById("MMP:MPMax").setAttribute("disabled","false");
		document.getElementById("MMP:MPMax").removeAttribute("disabled");
		break;
	  case "accountCentralBox": //Account Central
		disableMessagePaneToggling(true);
		document.getElementById("MMP:MPMax").setAttribute("disabled","true");
		break;
	  default: //Other deck
		disableMessagePaneToggling(true);
		document.getElementById("MMP:MPMax").setAttribute("disabled","true");
		break;
	}	
}

function jumpToFolder(target)
{
	var uri = target.getAttribute("id");
	SelectFolder(uri);
}

function getSelectedMsg()
{
	var currentMsgURI = null;
	var currentFolderURI = null;
	
	try {
		currentFolderURI = GetSelectedFolderURI();
	} catch(e) {
		currentFolderURI = null;
	}
	if (currentFolderURI) gMMPLastSelectedFolderURI = currentFolderURI;
	
	try {
		var currentMsgsURIs = GetSelectedMessages();
		currentMsgURI = currentMsgsURIs[0];
	} catch(e) {
		//Restore message pane if no message exists
		if (gDBView) {
			var msgNum = gDBView.msgFolder.getTotalMessages(false);
			if (msgNum < 1 && gIsMaxMsgPane) ToggleMaxMessagePane();
		}
		currentMsgURI = null;
	}
	if (currentMsgURI) gMMPLastSelectedMsgURI = currentMsgURI;
}

function restartTB()
{
	var localeBundle = document.getElementById("localeBundle");
	var pref = Components.classes["@mozilla.org/preferences-service;1"].getService(Components.interfaces.nsIPrefBranch);
	var promptService = Components.classes["@mozilla.org/embedcomp/prompt-service;1"].getService(Components.interfaces.nsIPromptService);
	var warn;
	try {
		warn = gMMPPref.getBoolPref("maxmsgpane.warn_restart");
	} catch (e) {
		warn = true;
	}
	
    if (warn) {
        var checkValue = {value:false};
        var buttonPressed = promptService.confirmEx(window, 
              localeBundle.getString("mmp.confirm_title"),
              localeBundle.getString("mmp.confirm_msg"),
              (promptService.BUTTON_TITLE_IS_STRING * promptService.BUTTON_POS_0) +
              (promptService.BUTTON_TITLE_CANCEL * promptService.BUTTON_POS_1),
              localeBundle.getString("mmp.restart_button"),
              null, null,
              localeBundle.getString("mmp.not_show"),
              checkValue);
        if (buttonPressed != 0) {
            return;
        }
        if (checkValue.value) {
            gMMPPref.setBoolPref("maxmsgpane.warn_restart", false);
        }
    }
	
	var appStartup = Components.classes["@mozilla.org/toolkit/app-startup;1"].getService(Components.interfaces.nsIAppStartup);
	appStartup.quit(appStartup.eAttemptQuit | appStartup.eRestart);
}

function autoSelectOnFolder()
{
	var orgVal = document.getElementById("mmp_navibar_auto_select").getAttribute("checked");
	document.getElementById("mmp_navibar_auto_select").setAttribute("checked","true");
	var autoSel = 4;
	try {
		autoSel = gMMPPref.getIntPref("maxmsgpane.auto_sel_msg");
	} catch(e) {};

	//the message has already been selected
	if (gDBView.currentlyDisplayedMessage != nsMsgViewIndex_None) autoSel = 4;

	switch (autoSel) {
	  case 0:
		selectMsgByMMPNaviBar(MMP_NAVI_BAR_FIRST);
		break;
	  case 1:
		selectMsgByMMPNaviBar(MMP_NAVI_BAR_FIRST_UNREAD);
		break;
	  case 2:
		selectMsgByMMPNaviBar(MMP_NAVI_BAR_LAST);
		break;
	  case 3:
		selectMsgByMMPNaviBar(MMP_NAVI_BAR_LAST_UNREAD);
		break;
	  default:
		dispMsgSubjectOnMMPNaviBar(MMP_NAVI_BAR_CUR,true);
		break;
	}
	document.getElementById("mmp_navibar_auto_select").setAttribute("checked",orgVal);
}

function showMMPNaviBar()
{
	autoSelectOnFolder();
	
	onMMPNaviAutoSelectChange();
	var naviBar = document.getElementById("mmp_navibar");
	naviBar.collapsed = false;
	naviBar.addEventListener("DOMMouseScroll",onScrollOnMMPNaviBar,true);
	var flagImg = document.getElementById("mmp_navibar_flag");
	var junkImg = document.getElementById("mmp_navibar_junk");
	if (MMPAppInfo.compareVersion(MMPAppInfo.getAppVersion(), "2.0a1") >= 0) {
		flagImg.setAttribute("tb","2.0");
		junkImg.setAttribute("tb","2.0");
	} else {
		flagImg.setAttribute("tb","1.5");
		junkImg.setAttribute("tb","1.5");
	}
	
	var threadTree = GetThreadTree();
	threadTree.addEventListener("select",resetMMPNaviBarCursor,true);
	var folderTree = GetFolderTree();
	folderTree.addEventListener("select",autoSelectOnFolder,true);
}

function resetMMPNaviBarCursor()
{
	autoSelectOnFolder();
	dispMsgSubjectOnMMPNaviBar(MMP_NAVI_BAR_CUR,true);
}

function hideMMPNaviBar()
{
	var naviBar = document.getElementById("mmp_navibar");
	if (naviBar.collapsed) return;

	naviBar.collapsed = true;
	naviBar.removeEventListener("DOMMouseScroll",onScrollOnMMPNaviBar,true);
	naviBar.setAttribute("msgIndex","0");
	var threadTree = GetThreadTree();
	threadTree.removeEventListener("select",resetMMPNaviBarCursor,true);
	var folderTree = GetFolderTree();
	folderTree.removeEventListener("select",autoSelectOnFolder,true);
}

function onScrollOnMMPNaviBar(aEvent)
{
	if (aEvent.detail > 0) selectMsgByMMPNaviBar(MMP_NAVI_BAR_NEXT);
	else selectMsgByMMPNaviBar(MMP_NAVI_BAR_PREV);
}

function onMMPNaviAutoSelectChange()
{
	var val = document.getElementById("mmp_navibar_auto_select").checked;
	document.getElementById("mmp_navi_button_read").setAttribute("disabled", val.toString());
	document.getElementById("mmp_navi_button_reset").setAttribute("disabled", val.toString());

	if (!val) dispMsgSubjectOnMMPNaviBar(MMP_NAVI_BAR_CUR,true);
}

function mouseOverMMPNaviButton(act)
{
	if (document.getElementById("mmp_navibar_auto_select").checked)
	  dispMsgSubjectOnMMPNaviBar(act,true);
	
}

function mouseOutMMPNaviButton()
{
	if (document.getElementById("mmp_navibar_auto_select").checked)
	  dispMsgSubjectOnMMPNaviBar(MMP_NAVI_BAR_CUR,true);
}

function dispMsgSubjectOnMMPNaviBar(act, update)
{
	var dispId = "mmp_navibar_subject";
	var barId = "mmp_navibar";
	var msgIndex;
	var autoSelect = document.getElementById("mmp_navibar_auto_select").checked;
	var cursorPos; //start point where search is started
	
	if (autoSelect) {
		cursorPos = gDBView.currentlyDisplayedMessage;
		if (cursorPos == nsMsgViewIndex_None) cursorPos = 0;
	} else {
		var val = document.getElementById(barId).getAttribute("msgIndex");
		if (val) cursorPos = parseInt(val);
		else cursorPos = 0;
		if (cursorPos < 0) cursorPos = 0; //currently no message is selected
	}

	var result = moveVirtualListCursor(act, cursorPos, true);
	msgIndex = result[0];
	
	var dispIndex = parseInt(document.getElementById(barId).getAttribute("msgIndex"));
	var doWrap = false;
	if (result[1] != 0) doWrap = true;
	if (!update && result[1] != 0) { //wrapped
		try {
			doWrap = gMMPPref.getBoolPref("maxmsgpane.default_wrap");
		} catch (e) {
			doWrap = true;
		}
		if (!doWrap) msgIndex = nsMsgViewIndex_None;
	}

	//don't move cursor because no message was found.
	if (msgIndex == nsMsgViewIndex_None) msgIndex = cursorPos;

	var isRead = true;
	var isJunk = false;
	var isFlag = false;
	var hasAttach = false;
	var msgSubject = "";
	var msgSender = "";
	var msgDate = 0;
	try {
		var msgKey = gDBView.getKeyAt(msgIndex);
		var folder = gDBView.getFolderForViewIndex(msgIndex);
		var msgHdr = folder.GetMessageHeader(msgKey);
//		var msgHdr = gDBView.db.GetMsgHdrForKey(msgKey);
		if (msgHdr) {
			msgSubject = getMsgSubject(msgIndex);
			msgSender = msgHdr.mime2DecodedAuthor;
			msgDate = msgHdr.dateInSeconds;
			isRead = msgHdr.isRead;
			var junkScore = msgHdr.getStringProperty("junkscore"); 
			isJunk = ((junkScore != "") && (junkScore != "0"));
			isFlag = msgHdr.isFlagged;
			hasAttach = folder.getMsgDatabase(msgWindow).HasAttachments(msgKey);
//			hasAttach = gDBView.db.HasAttachments(msgKey);
		} else {
			msgSubject = "";
			msgIndex = 0;
			msgSubject = "";
			msgSender = "";
			msgDate = 0;
		}
	} catch (e) {
		msgIndex = 0;
		msgSubject = "";
		msgSubject = "";
		msgSender = "";
		msgDate = 0;
	}

	document.getElementById(dispId).setAttribute("value",msgSubject);
	document.getElementById(dispId).setAttribute("isRead",isRead.toString());
	document.getElementById("mmp_navibar_subjecttip1").setAttribute("value", msgSubject);
	document.getElementById("mmp_navibar_subjecttip2").setAttribute("value", msgSender);

	var str = "";
	if (msgDate && msgDate != 0) {
		var milisec = msgDate * 1000;
		var date = new Date(milisec);
		str = date.toLocaleString();
	}
	var naviBar = document.getElementById(barId);
	if (naviBar.getAttribute("msgIndex") != msgIndex.toString()) {
		document.getElementById("mmp_navibar_wrap").setAttribute("isWrapped",doWrap.toString());
		var msg = "";
		if (doWrap) {
			var localeBundle = document.getElementById("localeBundle");
			if (result[1] == -1)
			  msg = localeBundle.getString("mmp.msg_wrap_first");
			else if (result[1] == 1)
			  msg = localeBundle.getString("mmp.msg_wrap_last");
			document.getElementById("mmp_navibar_wrap").setAttribute("tooltiptext",msg);
		}
		outputMessageToStatusBar(msg);
	}
	naviBar.setAttribute("msgIndex",msgIndex.toString());
	document.getElementById("mmp_navibar_subjecttip3").setAttribute("value",str);
	document.getElementById("mmp_navibar_read").setAttribute("isRead",isRead.toString());
	document.getElementById("mmp_navibar_attach").setAttribute("hasAttach",hasAttach.toString());

	document.getElementById("mmp_navibar_junk").setAttribute("isJunk",isJunk.toString());
	document.getElementById("mmp_navibar_flag").setAttribute("isFlagged",isFlag.toString());
}

//returns [cusorPos, wrapped] wrapped = -1(return to first), 0(no wrap), 1(return to last)
function moveVirtualListCursor(act, curDispMsgIndex, wrap)
{
	var dir, unread;
	var notFound = [nsMsgViewIndex_None, 0];
	
	switch (act) {
	  case MMP_NAVI_BAR_PREV:
		dir = -1;
		unread = false;
		break;
	  case MMP_NAVI_BAR_PREV_UNREAD:
		dir = -1;
		unread = true;
		break;
	  case MMP_NAVI_BAR_NEXT:
		dir = 1;
		unread = false;
		break;
	  case MMP_NAVI_BAR_NEXT_UNREAD:
		dir = 1;
		unread = true;
		break;
	  case MMP_NAVI_BAR_CUR:
		dir = 0;
		unread = false;
		break;
	  case MMP_NAVI_BAR_FIRST:
		dir = -2;
		unread = false;
		break;
	  case MMP_NAVI_BAR_LAST:
		dir = 2;
		unread = false;
		break;
	  case MMP_NAVI_BAR_FIRST_UNREAD:
		dir = -2;
		unread = true;
		break;
	  case MMP_NAVI_BAR_LAST_UNREAD:
		dir = 2;
		unread = true;
		break;
	  case MMP_NAVI_BAR_READ_IT:
		dir = 0;
		break;
	  default:
		dir = 0;
		break;
	}

	//no message is found
	if (curDispMsgIndex < 0 || curDispMsgIndex == nsMsgViewIndex_None)
	  if (Math.abs(dir) != 2) return notFound;
	
	if (dir == 0) return [gDBView.currentlyDisplayedMessage,0];
	
	var resultId = new Object;
	var resultIndex = new Object;
	var threadIndex = new Object;
	var naviTypeFirst, naviTypeLast;

	naviTypeFirst = nsMsgNavigationType.firstMessage;
	naviTypeLast = nsMsgNavigationType.lastMessage;
	
	gDBView.viewNavigate(naviTypeFirst, resultId, resultIndex, threadIndex, true);
	var firstMsgIndex = resultIndex.value;

	gDBView.viewNavigate(naviTypeLast, resultId, resultIndex, threadIndex, true);
	var lastMsgIndex = resultIndex.value;

	//first/last message
	if (!unread && dir == -2) return [firstMsgIndex,0];
	else if (!unread && dir == 2) return [lastMsgIndex,0];

	var msgIndex = curDispMsgIndex;
	var endIndex = curDispMsgIndex;
	//find first/last unread message
	//start with the edge of the message list and stop with the opposite edge
	if (unread && dir == -2) {
		msgIndex = firstMsgIndex - 1;
		dir = 1;
		endIndex = lastMsgIndex;
	} else if (unread && dir == 2) {
		msgIndex = lastMsgIndex + 1;
		dir = -1;
		endIndex = firstMsgIndex;
	}

	var wrapped = 0;

	do {
		msgIndex = msgIndex + dir;

		//wrap
		if (msgIndex < firstMsgIndex) {
			if (wrap) {
				msgIndex = lastMsgIndex;
				wrapped = 1;
			} else return notFound;
		} else if (msgIndex > lastMsgIndex) {
			if (wrap) {
				msgIndex = firstMsgIndex;
				wrapped = -1;
			} else return notFound;
		}
		
		if (!unread) break;

		try {
			var curDispMsgKey = gDBView.getKeyAt(msgIndex);
			var folder = gDBView.getFolderForViewIndex(msgIndex);
			var msgHdr = folder.GetMessageHeader(curDispMsgKey);
			//var msgHdr = gDBView.db.GetMsgHdrForKey(curDispMsgKey);
			if (!(msgHdr.isRead)) break;
		} catch (e) {
			return notFound;
		}
	} while (msgIndex != endIndex);

	//found but wrapped
	if (wrapped != 0 && msgIndex != endIndex) {
		return [msgIndex,wrapped];
	} else {
		return [msgIndex,0];
	}
}

function getMsgSubject(msgIndex)
{
	var treeView = gDBView.QueryInterface(Components.interfaces.nsITreeView);
	var treeSelection = treeView.selection;
	var tree = treeSelection.tree;
	var columns = tree.columns;
	var column = columns.getNamedColumn("subjectCol");
	return treeView.getCellText(parseInt(msgIndex),column);
}

function selectMsgByMMPNaviBar(act)
{
	if (act != MMP_NAVI_BAR_READ_IT) dispMsgSubjectOnMMPNaviBar(act,false);

	var autoSelect = document.getElementById("mmp_navibar_auto_select").checked;
	if (!autoSelect && act != MMP_NAVI_BAR_READ_IT) return;
	
	var treeView = gDBView.QueryInterface(Components.interfaces.nsITreeView);
	var treeSelection = treeView.selection;
	var msgIndex = document.getElementById("mmp_navibar").getAttribute("msgIndex");
	if (msgIndex && msgIndex != "-1") {
		treeSelection.select(parseInt(msgIndex));
		EnsureRowInThreadTreeIsVisible(parseInt(msgIndex));
	}
}

function markAsJunkFromMMPNaviBar()
{
	selectMsgByMMPNaviBar(MMP_NAVI_BAR_READ_IT);
	goDoCommand('button_junk');
	selectMsgByMMPNaviBar(MMP_NAVI_BAR_CUR);
}

function markAsFlaggedFromMMPNaviBar()
{
	selectMsgByMMPNaviBar(MMP_NAVI_BAR_READ_IT);
	goDoCommand('cmd_markAsFlagged');
	selectMsgByMMPNaviBar(MMP_NAVI_BAR_CUR);
}

function MMPNaviBarNavigate(act, event, clicked)
{
	var cmd = act;
	//clicked with pressing Shift key
	if (event.shiftKey) {
		switch (act) {
		  case MMP_NAVI_BAR_PREV:
			cmd = MMP_NAVI_BAR_FIRST;
			break;
		  case MMP_NAVI_BAR_NEXT:
			cmd = MMP_NAVI_BAR_LAST;
			break;
		  case MMP_NAVI_BAR_PREV_UNREAD:
			cmd = MMP_NAVI_BAR_FIRST_UNREAD;
			break;
		  case MMP_NAVI_BAR_NEXT_UNREAD:
			cmd = MMP_NAVI_BAR_LAST_UNREAD;
			break;
		  default:
			break;
		}
	}
	
	if (clicked) {
		selectMsgByMMPNaviBar(cmd);
	} else {
		if (event.type == "mouseover") mouseOverMMPNaviButton(cmd);
		else if (event.type == "mouseout") mouseOutMMPNaviButton();
	}
}