var gAcceptKeyChange = null; //id of button that accepts input
var gLocaleBundle;
var gCloseDlg = true;

var _elementIDs = [
	"MMPCollapseFolder",
	"MMPCollapseSearch",
	"MMPCollapseHeader",
	"MMPCollapseAttach",
	"shortcut_key",
	"shortcut-modifier-accel",
	"shortcut-modifier-alt",
	"shortcut-modifier-ctrl",
	"shortcut-modifier-meta",
	"shortcut-modifier-shift",
	"MMPToggleByMsgDClick",
	"MMPUseShortcut",
	"MMPToggleByHdr",
	"HdrMouseEvent",
	"MMPToggleByTSplitter",
	"TSMouseEvent",
	"TSActionList",
	"MMPToggleByFSplitter",
	"FSMouseEvent",
	"MMPUseFPShortcut",
	"MMPShowFPClsButton",
	"fp_shortcut_key",
	"fp-shortcut-modifier-accel",
	"fp-shortcut-modifier-alt",
	"fp-shortcut-modifier-ctrl",
	"fp-shortcut-modifier-meta",
	"fp-shortcut-modifier-shift",
	"MMPSaveSession",
	"MMPAutoRestart",
	"MMPWarnRestart",
	"MMPRestoreByFolSelChange",
	"MMPUseNavi",
	"MMPNaviAutoSelMsg"
];


function needRestart(ids)
{
	if (ids.length == 0) return false;
	for (var i=0; i<ids.length; i++) {
		var restart = document.getElementById(ids[i]).getAttribute("restart");
		if (restart == "true") return true;
	}

	return false;
}

function savePrefs() {
	if (!gCloseDlg){
		gCloseDlg = true;
		return false;
	}

	if (gAcceptKeyChange) cancelKeyChange(null);
	var pref =  Components.classes["@mozilla.org/preferences-service;1"].getService(Components.interfaces.nsIPrefBranch);
	var changedIDs = new Array();

	for( var i = 0; i < _elementIDs.length; i++ ) {
		var elementID = _elementIDs[i];
		var element = document.getElementById(elementID);
		
		if (!element) continue;
		
		var eltType = element.localName;
		var pre, post;
		if (eltType == "radiogroup") {
			pre = pref.getIntPref(element.getAttribute("prefstring"));
			post = parseInt(element.value);
			pref.setIntPref(element.getAttribute("prefstring"), parseInt(element.value));
		} else if (eltType == "checkbox") {
			pre = pref.getBoolPref(element.getAttribute("prefstring"));
			post = element.checked;
			pref.setBoolPref(element.getAttribute("prefstring"), element.checked);
		} else if (eltType == "textbox" && element.preftype == "int") {
			pre = pref.getIntPref(element.getAttribute("prefstring"));
			post = parseInt(element.getAttribute("value"));
			pref.setIntPref(element.getAttribute("prefstring"), parseInt(element.getAttribute("value")) );
		} else if (eltType == "textbox") {
			pre = pref.getCharPref(element.getAttribute("prefstring"));
			post = element.getAttribute("value");
			pref.setCharPref(element.getAttribute("prefstring"), element.value);
		} else if (eltType == "menulist") {
			if (element.getAttribute("id") == "TSActionList") {
				pre = pref.getBoolPref(element.getAttribute("prefstring"));
				post = element.selectedIndex == 0 ? false : true;
				pref.setBoolPref(element.getAttribute("prefstring"), post);
			} else {
				pre = pref.getIntPref(element.getAttribute("prefstring"));
				post = element.selectedIndex;
				pref.setIntPref(element.getAttribute("prefstring"), element.selectedIndex);
			}
		} else if (eltType == "label") {
			pre = pref.getCharPref(element.getAttribute("prefstring"));
			post = element.getAttribute("skey");
			pref.setCharPref(element.getAttribute("prefstring"), element.getAttribute("skey"));
		}
		if (pre != post) changedIDs.push(elementID);
	}

	var observerService = Components.classes["@mozilla.org/observer-service;1"].getService(Components.interfaces.nsIObserverService);
	var restart = "norestart";
	if (pref.getBoolPref("maxmsgpane.autorestart") && needRestart(changedIDs))
	  restart = "restart";
	observerService.notifyObservers(null, "mmp:setting_updated", restart);
	return true;
}


function cancelPrefs()
{
	if (gCloseDlg) return true;
	else {
		gCloseDlg = true;
		return false;
	}
}

function onLoad() {
	var pref = Components.classes["@mozilla.org/preferences-service;1"].getService(Components.interfaces.nsIPrefBranch);
	// initialize the default window values...
	for( var i = 0; i < _elementIDs.length; i++ ) {
		var elementID = _elementIDs[i];
		var element = document.getElementById(elementID);
		if (!element) continue;
		var eltType = element.localName;

		if (eltType == "radiogroup") {
			try {
				element.selectedItem = element.childNodes[pref.getIntPref(element.getAttribute("prefstring"))];
			} catch(e) {
				element.selectedItem = element.childNodes[element.getAttribute("defaultpref")];
				try {
					pref.setIntPref( element.getAttribute("prefstring"), element.getAttribute("defaultpref") );
				} catch (e) {}
			}
		} else if (eltType == "checkbox") {
			try {
				element.checked = ( pref.getBoolPref(element.getAttribute("prefstring")) == true );
			} catch(e) {
				element.checked = ( element.getAttribute("defaultpref") == "true" );
				try {
					pref.setBoolPref( element.getAttribute("prefstring"), element.checked );
				} catch(e){}
			}
		} else if (eltType == "textbox") {
			try {
				element.setAttribute("value", pref.getCharPref(element.getAttribute("prefstring")) );
			} catch(e) {
				element.setAttribute("value", element.getAttribute("defaultpref") );
			}
		} else if (eltType == "menulist") {
			try {
				if (element.getAttribute("id") == "TSActionList") {
					var set = pref.getBoolPref(element.getAttribute("prefstring"));
					var val = set ? 1 : 0;
					element.selectedIndex = val;
				} else {
					element.selectedIndex = pref.getIntPref(element.getAttribute("prefstring"));
				}
			} catch(e) {
				element.selectedIndex = element.getAttribute("defaultpref");
				try {
					if (element.getAttribute("id") == "TSActionList") {
						var val = element.selectedIndex == 0 ? false : true;
						pref.setBoolPref( element.getAttribute("prefstring"), val );
					} else {
						pref.setIntPref( element.getAttribute("prefstring"), element.selectedIndex );
					}
				} catch (e) {}
			}
		} else if (eltType == "label") {
			try {
				setLabel(element, pref.getCharPref(element.getAttribute("prefstring")));
				element.setAttribute("skey", pref.getCharPref(element.getAttribute("prefstring")) );
			} catch(e) {
				setLabel(element, element.getAttribute("defaultpref"));
				element.setAttribute("skey", element.getAttribute("defaultpref") );
				try {
					pref.setCharPref( element.getAttribute("prefstring"), element.getAttribute("defaultpref") );
				} catch(e){}
			}
		}
	}
	initDisabled();
}

function initDefault(elemIDs) {
	// initialize the default window values...
	for( var i = 0; i < elemIDs.length; i++ ) {
		var elementID = elemIDs[i];
		var element = document.getElementById(elementID);
		if (!element) break;
		
		var eltType = element.localName;

		if (eltType == "radiogroup") {
			element.selectedItem = element.childNodes[element.getAttribute("defaultpref")];
		} else if (eltType == "checkbox") {
			element.checked = ( element.getAttribute("defaultpref") == "true" );
		} else if (eltType == "textbox") {
			element.setAttribute("value", element.getAttribute("defaultpref") );
		} else if (eltType == "menulist") {
			element.selectedIndex = element.getAttribute("defaultpref");
		} else if (eltType == "label") {
			setLabel(element, element.getAttribute("defaultpref"));
			element.setAttribute("skey", element.getAttribute("defaultpref") );
		} else if (eltType == "menuitem") {
			element.setAttribute("selected", element.getAttribute("defaultpref") );
		}
	}
	initDisabled();
}

function defaultMP()
{
	var elemIDs = [
		"MMPCollapseFolder",
		"MMPCollapseSearch",
		"MMPCollapseHeader",
		"MMPCollapseAttach",
		"MMPToggleByMsgDClick",
		"MMPUseShortcut",
		"MMPToggleByHdr",
		"HdrMouseEvent",
		"MMPToggleByTSplitter",
		"TSMouseEvent",
		"MMPRestoreByFolSelChange",
		"TSActionList"
	];

	initDefault(elemIDs);
}

function defaultFP()
{
	var elemIDs = [
		"MMPToggleByFSplitter",
		"FSMouseEvent",
		"MMPUseFPShortcut",
		"MMPShowFPClsButton"
	];

	initDefault(elemIDs);
}

function defaultShortcutKey()
{
	var elemIDs = [
		"shortcut_key",
		"shortcut-modifier-accel",
		"shortcut-modifier-alt",
		"shortcut-modifier-ctrl",
		"shortcut-modifier-meta",
		"shortcut-modifier-shift",
		"fp_shortcut_key",
		"fp-shortcut-modifier-accel",
		"fp-shortcut-modifier-alt",
		"fp-shortcut-modifier-ctrl",
		"fp-shortcut-modifier-meta",
		"fp-shortcut-modifier-shift"
	];

	initDefault(elemIDs);
}

function defaultMisc()
{
	var elemIDs = [
		"MMPSaveSession",
		"MMPAutoRestart",
		"MMPWarnRestart",
		"MMPUseNavi",
		"MMPNaviAutoSelMsg"
	];

	initDefault(elemIDs);
}

function init()
{
	gLocaleBundle = document.getElementById("localeBundle");
}

function initDisabled()
{
	var val = document.getElementById("MMPToggleByHdr").checked;
	val = (!val).toString();
	document.getElementById("radio_hdrsclk").setAttribute("disabled",val);
	document.getElementById("radio_hdrdclk").setAttribute("disabled",val);

	val = document.getElementById("MMPToggleByTSplitter").checked;
	val = (!val).toString();
	document.getElementById("tsplitter_sclk").setAttribute("disabled",val);
	document.getElementById("tsplitter_dclk").setAttribute("disabled",val);
	document.getElementById("tsplitter_action_label").setAttribute("disabled",val);
	document.getElementById("TSActionList").setAttribute("disabled",val);
	
	val = document.getElementById("MMPToggleByFSplitter").checked;
	val = (!val).toString();
	document.getElementById("fsplitter_sclk").setAttribute("disabled",val);
	document.getElementById("fsplitter_dclk").setAttribute("disabled",val);

	val = document.getElementById("MMPAutoRestart").checked;
	val = (!val).toString();
	document.getElementById("MMPWarnRestart").setAttribute("disabled",val);

	if (MMPAppInfo.compareVersion(MMPAppInfo.getAppVersion(), "2.0a1") >= 0) {
		document.getElementById("MMPCollapseSearch").setAttribute("hidden","true");
	}

	val = document.getElementById("MMPUseNavi").getAttribute("checked");
	document.getElementById("MMPSet:UseNavi").setAttribute("disabled",(!val).toString());
}

//If aEvent == null then cancel key change
function controlKeyChange(aEvent)
{

	var buttonStr1 = gLocaleBundle.getString("mmpset.chkey");
	var buttonStr2 = gLocaleBundle.getString("mmpset.skey_cancel");
	var prompt = gLocaleBundle.getString("mmpset.skey_prompt");
	var changeButton;
	var promptLabel;
	var buttonId = null;

	if (!aEvent) buttonId = gAcceptKeyChange;
	else buttonId = aEvent.originalTarget.getAttribute("id");
		
	if (buttonId == "change_key") {
		//Shortcut key for MP toggle
		changeButton = document.getElementById("change_key");
		promptLabel = document.getElementById("shortcut_key");
	} else if (buttonId == "fp_change_key") {
		//Shortcut key for FP toggle
		changeButton = document.getElementById("fp_change_key");
		promptLabel = document.getElementById("fp_shortcut_key");
	} else {
		return;
	}
	
	if (!gAcceptKeyChange) {
		changeButton.setAttribute("label", buttonStr2);
		gAcceptKeyChange = changeButton.getAttribute("id");
		promptLabel.setAttribute("value", prompt);
	} else {
		changeButton.setAttribute("label", buttonStr1);
		gAcceptKeyChange = null;
		var skey = promptLabel.getAttribute("skey");
		setLabel(promptLabel, skey);
	}
}

function cancelKeyChange(aEvent)
{
	if (gAcceptKeyChange != null) controlKeyChange(aEvent);
}

function changeKey(aEvent)
{
//	aEvent.preventBubble();
	aEvent.stopPropagation();
	if (!gAcceptKeyChange) return;

	var promptLabel;
	if (aEvent.originalTarget.getAttribute("id") == "change_key") {
		//Shortcut key for MP toggle
		promptLabel = document.getElementById("shortcut_key");		
	} else if (aEvent.originalTarget.getAttribute("id") == "fp_change_key") {
		//Shortcut key for FP toggle
		promptLabel = document.getElementById("fp_shortcut_key");
	} else {
		//illegal event
		return;
	}

	if (aEvent.keyCode != 0) {
		var keystr = keyCodeToVK(aEvent);
		if (keystr != null)
		  promptLabel.setAttribute("skey",keystr);
		else return;
	} else {
		promptLabel.setAttribute("skey",String.fromCharCode(aEvent.which).toUpperCase());
	}
	
	controlKeyChange(aEvent);
}

function setLabel(label, str)
{
	switch (str) {
	  case " ":
		label.setAttribute("value","SPACE");
		break;
	  default:
		var substr = null;
		var i = str.indexOf("VK_");
		if (i != -1) substr = str.substring(i+3, str.length);
		else substr = str;
		label.setAttribute("value",substr);
	}
}

function keyCodeToVK(event)
{
	var keyStr;
	switch (event.keyCode) {
	  case event.DOM_VK_CANCEL:		keyStr = "VK_CANCEL"; break;
	  case event.DOM_VK_HELP:		keyStr = "VK_HELP"; break;
	  case event.DOM_VK_BACK_SPACE:	keyStr = "VK_BACK_SPACE"; break;
	  case event.DOM_VK_TAB:		keyStr = "VK_TAB"; break;
	  case event.DOM_VK_CLEAR:		keyStr = "VK_CLEAR"; break;
	  case event.DOM_VK_RETURN:		keyStr = "VK_RETURN"; break;
	  case event.DOM_VK_ENTER:		keyStr = "VK_ENTER"; break;
	  case event.DOM_VK_PAUSE:		keyStr = "VK_PAUSE"; break;
	  case event.DOM_VK_CAPS_LOCK:	keyStr = "VK_CAPS_LOCK"; break;
	  case event.DOM_VK_ESCAPE:		keyStr = "VK_ESCAPE"; gCloseDlg = false; break;
	  case event.DOM_VK_PAGE_UP:	keyStr = "VK_PAGE_UP"; break;
	  case event.DOM_VK_PAGE_DOWN:	keyStr = "VK_PAGE_DOWN"; break;
	  case event.DOM_VK_END:		keyStr = "VK_END"; break;
	  case event.DOM_VK_HOME:		keyStr = "VK_HOME"; break;
	  case event.DOM_VK_LEFT:		keyStr = "VK_LEFT"; break;
	  case event.DOM_VK_UP:			keyStr = "VK_UP"; break;
	  case event.DOM_VK_RIGHT:		keyStr = "VK_RIGHT"; break;
	  case event.DOM_VK_DOWN:		keyStr = "VK_DOWN"; break;
	  case event.DOM_VK_PRINTSCREEN: keyStr = "VK_PRINTSCREEN"; break;
	  case event.DOM_VK_INSERT:		keyStr = "VK_INSERT"; break;
	  case event.DOM_VK_DELETE:		keyStr = "VK_DELETE"; break;
	  case event.DOM_VK_F1:			keyStr = "VK_F1"; break;
	  case event.DOM_VK_F2:			keyStr = "VK_F2"; break;
	  case event.DOM_VK_F3:			keyStr = "VK_F3"; break;
	  case event.DOM_VK_F4:			keyStr = "VK_F4"; break;
	  case event.DOM_VK_F5:			keyStr = "VK_F5"; break;
	  case event.DOM_VK_F6:			keyStr = "VK_F6"; break;
	  case event.DOM_VK_F7:			keyStr = "VK_F7"; break;
	  case event.DOM_VK_F8:			keyStr = "VK_F8"; break;
	  case event.DOM_VK_F9:			keyStr = "VK_F9"; break;
	  case event.DOM_VK_F10:		keyStr = "VK_F10"; break;
	  case event.DOM_VK_F11:		keyStr = "VK_F11"; break;
	  case event.DOM_VK_F12:		keyStr = "VK_F12"; break;
	  case event.DOM_VK_F13:		keyStr = "VK_F13"; break;
	  case event.DOM_VK_F14:		keyStr = "VK_F14"; break;
	  case event.DOM_VK_F15:		keyStr = "VK_F15"; break;
	  case event.DOM_VK_F16:		keyStr = "VK_F16"; break;
	  case event.DOM_VK_F17:		keyStr = "VK_F17"; break;
	  case event.DOM_VK_F18:		keyStr = "VK_F18"; break;
	  case event.DOM_VK_F19:		keyStr = "VK_F19"; break;
	  case event.DOM_VK_F20:		keyStr = "VK_F20"; break;
	  case event.DOM_VK_F21:		keyStr = "VK_F21"; break;
	  case event.DOM_VK_F22:		keyStr = "VK_F22"; break;
	  case event.DOM_VK_F23:		keyStr = "VK_F23"; break;
	  case event.DOM_VK_F24:		keyStr = "VK_F24"; break;
	  case event.DOM_VK_NUM_LOCK:	keyStr = "VK_NUM_LOCK"; break;
	  case event.DOM_VK_SCROLL_LOCK: keyStr = "VK_SCROLL_LOCK";	break;
	  default:						keyStr = null; break;
	}
	return keyStr;
}

window.addEventListener("load", init, false);

