/*
  The contents of this file are subject to the Mozilla Public License
  Version 1.1 (the "MPL"); you may not use this file except in compliance
  with the Licens. You may obtain a copy of the MPL at
  http://www.mozilla.org/MPL/

  Software distributed under the MPL is distributed on an "AS IS" basis,
  WITHOUT WARRANTY OF ANY KIND, either express or implied. See the MPL
  for the specific language governing rights and limitations under the
  MPL.

  The Original Code is Forward Extension.

  The Initial Developer of the Original Code is Onno Ekker.
  Portions created by Onno Ekker <o.e.ekker@gmail.com> are Copyright (c)
  2008. All Rights Reserved.

  Alternatively, the contents of this file may be used under the terms
  terms of the GNU General Public License (the "GPL"), in which case the
  provisions of the GPL are applicable instead of those above. If you
  wish to allow use of your version of this file only under the terms of
  the GPL and not to allow others to use your version of this file under
  the MPL, indicate your decision by deleting the provisions above and
  replace them with the notice and other provisions required by the GPL.
  If you do not delete the provisions above, a recipient may use your
  version of this file under either the MPL or the GPL.
*/

var myForwardExtension = {

  myLogToErrorConsole: function(aMessage, aSourceName, aSourceLine, aLineNumber, 
                                aColumnNumber, aFlags, aCategory)
  {
    var consoleService = Components.classes["@mozilla.org/consoleservice;1"]
                                 .getService(Components.interfaces.nsIConsoleService);
    if (aFlags == null)
      consoleService.logStringMessage(aMessage);
    else
    {
      var scriptError = Components.classes["@mozilla.org/scripterror;1"]
                                  .createInstance(Components.interfaces.nsIScriptError);
      scriptError.init(aMessage, aSourceName, aSourceLine, aLineNumber, 
                       aColumnNumber, aFlags, aCategory);
      consoleService.logMessage(scriptError);
    }
  },

  // forward-button

  updateForwardButtonMenu: function(event)
  {
    var forwardType = 0;
    var forwardInlineMenuItem = document.getElementById('button-forwardAsMenu-forwardInline');
    var forwardAsAttachmentMenuItem = document.getElementById('button-forwardAsMenu-forwardAsAttachment');

    function ucfirst(menuItem)
    {
      var origLabel = menuItem.getAttribute('label');
      var newLabel = origLabel.replace(/^(\S)/, function(t, a) { return a.toLocaleUpperCase(); });
      if (newLabel != origLabel) menuItem.setAttribute('label', newLabel);
    }

    // mail.forward_message_mode could be 1, if the user migrated from 4.x
    // 1 (forward as quoted) is obsolete, so we treat is as forward inline
    // since that is more like forward as quoted then forward as attachment
    try {
      forwardType = gPrefBranch.getIntPref('mail.forward_message_mode');
    }
    catch (ex) {
      myLogToErrorConsole(ex, 'chrome://forward/content/forward.js',
                          '    forwardType = gPrefBranch.getIntPref(\'mail.forward_message_mode\');',
                          65, 0, 2, 'javascript');
      forwardType = 2; // Let's make Inline the default
    }

    if (forwardInlineMenuItem) {
      forwardInlineMenuItem.setAttribute('default', (forwardType != 0));
      ucfirst(forwardInlineMenuItem);
    }
    if (forwardAsAttachmentMenuItem) {
      forwardAsAttachmentMenuItem.setAttribute('default', (forwardType == 0));
      ucfirst(forwardAsAttachmentMenuItem);
    }

    var headerForwardButton = document.getElementById('hdrForwardButton');  // Thunderbird 3.0 pre ..
    var setStyle = (headerForwardButton != null);
    if (headerForwardButton == null) {
      var headerViewButtonBox = document.getElementById('msgHeaderViewDeck').selectedPanel
                                        .getElementsByTagName("header-view-button-box").item(0);  // Thunderbird 3.0a1 .. 3.0b4
      if (headerViewButtonBox != null) {
        headerForwardButton = document.getAnonymousElementByAttribute(headerViewButtonBox, 'anonid', 'hdrForwardButton');
      }
    }
    if (headerForwardButton != null) {
      if (headerForwardButton.hasAttribute('type')) { // Dropdown menu already exists, update if pref change
        var headerForwardButtonFirstChild = document.getElementById('hdrForwardButtonFirstChild');
        var headerForwardButtonLastChild = document.getElementById('hdrForwardButtonLastChild');
        
        if (forwardType == 0) {
          if (headerForwardButtonLastChild.hasAttribute('hidden')) {  // Show as attachment as first item
            headerForwardButtonFirstChild.setAttribute('hidden', 'true'); // by hiding first and showing last
            headerForwardButtonLastChild.removeAttribute('hidden');
          }
        } else {
          if (headerForwardButtonFirstChild.hasAttribute('hidden')) { // Show inline as first item
            headerForwardButtonFirstChild.removeAttribute('hidden');  // by showing first and hiding last
            headerForwardButtonLastChild.setAttribute('hidden', 'true');
          }
        }
      } else {
        var strbundle = document.getElementById('bundle_forward');
        var region = window.getComputedStyle(headerForwardButton, null).getPropertyValue('-moz-image-region');
        var menuitem;
        headerForwardButton.setAttribute('type', 'menu-button');
        headerForwardButton.setAttribute('class', 'msgHeaderView-button hdrReplyButton');  // Make forward button look like reply button
        if (setStyle) headerForwardButton.setAttribute('style', '-moz-image-region: ' + region + ';');  // except for the icon
        headerForwardButton.appendChild(document.createElement('menupopup'));
        headerForwardButton = headerForwardButton.firstChild;
        
        menuitem = headerForwardButton.appendChild(document.createElement('menuitem'));
        menuitem.setAttribute('id', 'hdrForwardButtonFirstChild');
        menuitem.setAttribute('label', strbundle.getString('inline.label'));
        menuitem.setAttribute('tooltiptext', strbundle.getString('hdrForwardButton.tooltip'));
        menuitem.setAttribute('oncommand', 'MsgForwardAsInline(event); event.stopPropagation(); RestoreFocusAfterHdrButton();');
        if (forwardType == 0) { menuitem.setAttribute('hidden', 'true'); }  // Show first depending on pref

        menuitem = headerForwardButton.appendChild(document.createElement('menuitem'));
        menuitem.setAttribute('label', strbundle.getString('asAttachment.label'));
        menuitem.setAttribute('tooltiptext', strbundle.getString('hdrForwardButton.tooltip'));
        menuitem.setAttribute('oncommand', 'MsgForwardAsAttachment(event); event.stopPropagation(); RestoreFocusAfterHdrButton();');

        menuitem = headerForwardButton.appendChild(document.createElement('menuitem'));
        menuitem.setAttribute('id', 'hdrForwardButtonLastChild');
        menuitem.setAttribute('label', strbundle.getString('inline.label'));
        menuitem.setAttribute('tooltiptext', strbundle.getString('hdrForwardButton.tooltip'));
        menuitem.setAttribute('oncommand', 'MsgForwardAsInline(event); event.stopPropagation(); RestoreFocusAfterHdrButton();');
        if (forwardType != 0) { menuitem.setAttribute('hidden', 'true'); }  // Show last depending on pref
      }
    }
  },

  // threadPane and messagePane menu menuitem

  SetupForwardAsMenuMenuItem: function (menuID, numSelected, forceHide)
  {
    ShowMenuItem(menuID, (numSelected <= 1) && !forceHide);
    EnableMenuItem(menuID, (numSelected == 1));
  },

  // threadPane

  forward_fillThreadPaneContextMenu: function ()
  {
    var numSelected = GetNumSelectedMessages();
    myForwardExtension.SetupForwardAsMenuMenuItem("threadPaneContext-forwardAsMenu", numSelected, false);
  },

  // messagePane

  forward_fillMessagePaneContextMenu: function ()
  {
    var message = GetLoadedMessage();
    var numSelected = (message) ? 1 : 0;

    // don't show mail items for links/images, just show related items.
    var hideMailItems = gContextMenu.onImage || gContextMenu.onLink;
    myForwardExtension.SetupForwardAsMenuMenuItem("messagePaneContext-forwardAsMenu", numSelected, (numSelected == 0 || hideMailItems));
  },

  // Event listeners

  installListeners: function (event)
  {
    var el;
    el = document.getElementById("threadPaneContext");
    if (el) el.addEventListener("popupshowing", myForwardExtension.forward_fillThreadPaneContextMenu, false);

    el = document.getElementById("messagePaneContext");
    if (el) el.addEventListener("popupshowing", myForwardExtension.forward_fillMessagePaneContextMenu, false);
  },

  uninstallListeners: function (event)
  {
    var el;
    el = document.getElementById("threadPaneContext");
    if (el) el.removeEventListener("popupshowing", myForwardExtension.forward_fillThreadPaneContextMenu, false);

    el = document.getElementById("messagePaneContext");
    if (el) el.removeEventListener("popupshowing", myForwardExtension.forward_fillMessagePaneContextMenu, false);
  },

  // Pref observer

  register: function()
  {
    var prefService = Components.classes["@mozilla.org/preferences-service;1"]
                                .getService(Components.interfaces.nsIPrefService);
    this._forward_message_mode = prefService.getBranch("mail.forward_message_mode");  // Forward mode
    this._forward_message_mode.QueryInterface(Components.interfaces.nsIPrefBranch2);
    this._forward_message_mode.addObserver("", this, false);

    this._pane_config_dynamic = prefService.getBranch("mail.pane_config.dynamic");  // Layout change
    this._pane_config_dynamic.QueryInterface(Components.interfaces.nsIPrefBranch2);
    this._pane_config_dynamic.addObserver("", this, false);
  },

  unregister: function()
  {
    if(!this._forward_message_mode) return;
    this._forward_message_mode.removeObserver("", this);
    this._pane_config_dynamic.removeObserver("", this);
  },

  observe: function(aSubject, aTopic, aData)
  {
    if(aTopic != "nsPref:changed") return;
    this.updateForwardButtonMenu();
  },

  updateCheck: function()
  {
    var version = "";
    try {
      version = gPrefBranch.getCharPref("extensions.forward@mozdev.org.version");
    }
    catch (ex) {
    }

    var versionChecker = Components.classes["@mozilla.org/xpcom/version-comparator;1"]
                               .getService(Components.interfaces.nsIVersionComparator);

    if (versionChecker.compare(version, "0.8") < 0) {
      gPrefBranch.setCharPref("extensions.forward@mozdev.org.version", "0.8");
      openLinkExternally("http://forward.mozdev.org");
    }
  }
}

// Hightlight default forward mode
window.addEventListener("load", myForwardExtension.updateForwardButtonMenu, false);

window.addEventListener("load", myForwardExtension.installListeners, false);
window.addEventListener("unload", myForwardExtension.uninstallListeners, false);

// Watch for preference changes
myForwardExtension.register();

myForwardExtension.updateCheck();
